

path = "C:/Users/ab998/OneDrive - University of Exeter/TDP43 project JG/manuscript/elife/VOR final files/scripts"


celldf = read.table(file = paste(path, "/E5_neurite.txt", sep=""), sep="\t", header=T)

nesdf = celldf[, c("sample", "replicate", "cyto_nuc")]
colnames(nesdf) = c("condition", "replicate", "value")
nesdf$condition[which(nesdf$condition == "nes0")] = "Control"
nesdf$condition[which(nesdf$condition == "nesm")] = "NES"



################################################################################
## colors 

colors <- c("deepskyblue4", "green4", "red3") # Colors for the replicates
colors.class <- c("coral1", "dodgerblue", "deepskyblue") # Colors for the replicates
col.bin = "grey80"
img.w = 6
img.h = 6
img.u = "in"
marvec = c(4,7,2,2)
boxwex = 0.5
x.cex = 3
cexval = 0.8
lwd=4
lwd.tick=4

################################################################################

filename = paste(path, "/figures/E5-neusoma-NC-v11-boxplot.tiff", sep="")
tiff(filename, width=img.w, height=img.h, units=img.u, res=300, compression = "jpeg")

par(mar = marvec + 0.1)
posvec = c(1,2,3,4)

boxplot(nesdf$value[which(nesdf$condition == "Control")], nesdf$value[which(nesdf$condition == "NES")], 0,0, outline=F, las=2, ylim=c(0,100),
        lwd=lwd, boxwex=boxwex, frame=F, col=colors.class[c(1,3)],
        at=posvec, axes=FALSE
)
axis(2, cex.axis=x.cex, las=2, lwd=lwd)

dev.off()

###

filename = paste(path, "/figures/E5-neusoma-NC-v11-boxplot-with-datapoints.tiff", sep="")

tiff(filename, width=img.w, height=img.h, units=img.u, res=300, compression = "jpeg")

par(mar = marvec + 0.1)
posvec = c(1,2,3,4)

boxplot(nesdf$value[which(nesdf$condition == "Control")], nesdf$value[which(nesdf$condition == "NES")], 0,0, outline=F, las=2, ylim=c(0,100),
        lwd=lwd, boxwex=boxwex, frame=F, col=rep(col.bin, 2),
        at=posvec, axes=FALSE
)
axis(2, cex.axis=x.cex, las=2, lwd=lwd, lwd.ticks=lwd.tick)


# Step 3: Overlay individual points, colored by replicate

condvec = c("Control", "NES")
repvec = c("R1", "R2", "R3")
rep.posvec = c(-0.25, 0, 0.25)

numdp.df = data.frame(matrix(0, nrow=length(condvec), ncol=length(repvec)))
rownames(numdp.df) = condvec
colnames(numdp.df) = repvec

for (i in 1:length(condvec)) {
  for (j in 1:length(repvec)) {
    subset_data <- nesdf[which(nesdf$condition == condvec[i] & nesdf$replicate == repvec[j]), ]
    points(jitter(rep(posvec[i]+rep.posvec[j], length(subset_data$condition)), amount=0.1), subset_data$value, col = colors[as.numeric(j)], pch = 20, cex=cexval)
    
    numdp.df[i,j] = length(subset_data$condition)
  }
}

dev.off()

numdp.df$condition = rownames(numdp.df)
write.table(numdp.df, file = paste(path, "/figures/E5-neusoma-NC-v11-boxplot-with-datapoints_numbers.txt", sep=""), sep="\t", 
            col.names = T, row.names = F, quote = F)

################################################################################
################################################################################

high_ratio = 80
low_ratio = 40


tmpdf = celldf[which(celldf$sample == "nes0" | celldf$sample == "nesm"), 
               c("sample", "replicate", "soma_NumberTrunks_m2", "soma_NumberBranchEnds_m2", "soma_SkeletonLength_m2", "soma_Area", "cyto_nuc", "nuc_FileName_DNA",
                 "nuc_Location_Center_X", "nuc_Location_Center_Y")]

colnames(tmpdf) = c("condition", "replicate", "soma_NumberTrunks", "soma_NumberBranchEnds", "soma_SkeletonLength", "soma_Area", "cyto_nuc", "nuc_FileName_DNA", "X", "Y")


tmpdf$class = "unk"
tmpdf$class[which(tmpdf$condition == "nes0")] = "Nuc"
tmpdf$class[which(tmpdf$condition == "nesm" & tmpdf$cyto_nuc > low_ratio)] = "Misloc_1"
tmpdf$class[which(tmpdf$condition == "nesm" & tmpdf$cyto_nuc <= low_ratio)] = "Misloc_2"

table(tmpdf$class)

med.skl = median(tmpdf$soma_SkeletonLength[which(tmpdf$class == "Nuc")])
med.soma = median(tmpdf$soma_Area[which(tmpdf$class == "Nuc")])


for(rep in c("R1", "R2", "R3")){
  
  tmpdf$soma_SkeletonLength[which(tmpdf$replicate == rep)] = tmpdf$soma_SkeletonLength[which(tmpdf$replicate == rep)] / 
    median(tmpdf$soma_SkeletonLength[which(tmpdf$replicate == rep & tmpdf$class == "Nuc")])  
  
  tmpdf$soma_Area[which(tmpdf$replicate == rep)] = tmpdf$soma_Area[which(tmpdf$replicate == rep)] / 
    median(tmpdf$soma_Area[which(tmpdf$replicate == rep & tmpdf$class == "Nuc")])
  
  tmpdf$soma_NumberTrunks[which(tmpdf$replicate == rep)] = tmpdf$soma_NumberTrunks[which(tmpdf$replicate == rep)] / 
    median(tmpdf$soma_NumberTrunks[which(tmpdf$replicate == rep & tmpdf$class == "Nuc")])
  
  tmpdf$soma_NumberBranchEnds[which(tmpdf$replicate == rep)] =  tmpdf$soma_NumberBranchEnds[which(tmpdf$replicate == rep)] / 
    median(tmpdf$soma_NumberBranchEnds[which(tmpdf$replicate == rep & tmpdf$class == "Nuc")])
  
}

#########################################################################################

pvaldf = data.frame(matrix(nrow=7, ncol=4))

bin01 = wilcox.test(tmpdf$soma_SkeletonLength[which(tmpdf$class == "Nuc")], tmpdf$soma_SkeletonLength[which(tmpdf$class == "Misloc_1")])
bin02 = wilcox.test(tmpdf$soma_SkeletonLength[which(tmpdf$class == "Nuc")], tmpdf$soma_SkeletonLength[which(tmpdf$class == "Misloc_2")])
bin12 = wilcox.test(tmpdf$soma_SkeletonLength[which(tmpdf$class == "Misloc_1")], tmpdf$soma_SkeletonLength[which(tmpdf$class == "Misloc_2")])

pvaldf[1, ] = c("SkelLength.p.bin01", bin01$p.value, length(tmpdf$soma_SkeletonLength[which(tmpdf$class == "Nuc")]), 
                                                                       length(tmpdf$soma_SkeletonLength[which(tmpdf$class == "Misloc_1")]))

pvaldf[2, ] = c("SkelLength.p.bin02", bin02$p.value, length(tmpdf$soma_SkeletonLength[which(tmpdf$class == "Nuc")]), 
                                                                       length(tmpdf$soma_SkeletonLength[which(tmpdf$class == "Misloc_2")]))

pvaldf[3, ] = c("SkelLength.p.bin12", bin12$p.value, length(tmpdf$soma_SkeletonLength[which(tmpdf$class == "Misloc_1")]), 
                                                                       length(tmpdf$soma_SkeletonLength[which(tmpdf$class == "Misloc_2")]))

bin01 = wilcox.test(tmpdf$soma_Area[which(tmpdf$class == "Nuc")], tmpdf$soma_Area[which(tmpdf$class == "Misloc_1")])
bin02 = wilcox.test(tmpdf$soma_Area[which(tmpdf$class == "Nuc")], tmpdf$soma_Area[which(tmpdf$class == "Misloc_2")])
bin12 = wilcox.test(tmpdf$soma_Area[which(tmpdf$class == "Misloc_1")], tmpdf$soma_Area[which(tmpdf$class == "Misloc_2")])

pvaldf[4, ] = c("SomaArea.p.bin01", bin01$p.value, length(tmpdf$soma_Area[which(tmpdf$class == "Nuc")]), 
                length(tmpdf$soma_Area[which(tmpdf$class == "Misloc_1")]))

pvaldf[5, ] = c("SomaArea.p.bin02", bin02$p.value, length(tmpdf$soma_Area[which(tmpdf$class == "Nuc")]), 
                length(tmpdf$soma_Area[which(tmpdf$class == "Misloc_2")]))

pvaldf[6, ] = c("SomaArea.p.bin12", bin12$p.value, length(tmpdf$soma_Area[which(tmpdf$class == "Misloc_1")]), 
                length(tmpdf$soma_Area[which(tmpdf$class == "Misloc_2")]))

nc = wilcox.test(nesdf$value[which(nesdf$condition == "Control")], nesdf$value[which(nesdf$condition == "NES")])
pvaldf[7, ] = c("NC", nc$p.value, length(nesdf$value[which(nesdf$condition == "Control")]), length(nesdf$value[which(nesdf$condition == "NES")]))


write.table(pvaldf, paste(path, "/figures/E5-NC-neurite-soma-pvals.txt", sep=""), sep="\t", row.names = F, col.names = F, quote = F)


#########################################################################################
### plot neurite


filename = paste(path, "/figures/E5-neurite-boxplot-nes0-nesm.tiff", sep="")
tiff(filename, width=img.w, height=img.h, units=img.u, res=300, compression = "jpeg")

par(mar = marvec + 0.1)
posvec = c(1,2,3)

boxplot(tmpdf$soma_SkeletonLength[which(tmpdf$class == "Nuc")], 
        tmpdf$soma_SkeletonLength[which(tmpdf$class == "Misloc_1")],
        tmpdf$soma_SkeletonLength[which(tmpdf$class == "Misloc_2")],
        
        outline=F, las=2, ylim=c(0,4),
        lwd=lwd, boxwex=boxwex, frame=F, col=colors.class,
        at=posvec, axes=FALSE
)
axis(2, cex.axis=x.cex, las=2, lwd=lwd, lwd.ticks=lwd.tick)

dev.off()

###

filename = paste(path, "/figures/E5-neurite-boxplot-nes0-nesm-with-datapoints.tiff", sep="")
tiff(filename, width=img.w, height=img.h, units=img.u, res=300, compression = "jpeg")

par(mar = marvec + 0.1)
posvec = c(1,2.5,4)

boxplot(tmpdf$soma_SkeletonLength[which(tmpdf$class == "Nuc")], 
        tmpdf$soma_SkeletonLength[which(tmpdf$class == "Misloc_1")],
        tmpdf$soma_SkeletonLength[which(tmpdf$class == "Misloc_2")],
        
        outline=F, las=2, ylim=c(0,4),
        lwd=lwd, boxwex=boxwex, frame=F, col=rep(col.bin, 3),
        at=posvec, axes=FALSE
)
axis(2, cex.axis=x.cex, las=2, lwd=lwd, lwd.ticks=lwd.tick)

# Step 3: Overlay individual points, colored by replicate

classvec = c("Nuc", "Misloc_1", "Misloc_2")
repvec = c("R1", "R2", "R3")
rep.posvec = c(-0.25, 0, 0.25)

numdp.df = data.frame(matrix(0, nrow=length(classvec), ncol=length(repvec)))
rownames(numdp.df) = classvec
colnames(numdp.df) = repvec

for (i in 1:length(classvec)) {
    subset_data <- tmpdf[which(tmpdf$class == classvec[i]), c("replicate", "soma_SkeletonLength")]
    colnames(subset_data)[2] = "value"
    
    for (j in 1:length(repvec)) {
       repdata = subset_data$value[which(subset_data$replicate == repvec[j])]
       points(jitter(rep(posvec[i]+rep.posvec[j], length(repdata)), amount=0.1), repdata, col = colors[as.numeric(j)], pch = 20, cex=cexval)
       
       numdp.df[i,j] = length(repdata)
    }
    
}

dev.off()

numdp.df$class = rownames(numdp.df)
write.table(numdp.df, file = paste(path, "/figures/E5-neurite-boxplot-nes0-nesm-with-datapoints_numbers.txt", sep=""), sep="\t", 
            col.names = T, row.names = F, quote = F)



###############################################################################
### plot soma

filename = paste(path, "/figures/E5-somaarea-boxplot-nes0-nesm.tiff", sep="")
tiff(filename, width=img.w, height=img.h, units=img.u, res=300, compression = "jpeg")

par(mar = marvec + 0.1)
posvec = c(1,2,3)

boxplot(tmpdf$soma_Area[which(tmpdf$class == "Nuc")], 
        tmpdf$soma_Area[which(tmpdf$class == "Misloc_1")],
        tmpdf$soma_Area[which(tmpdf$class == "Misloc_2")],
        
        outline=F, las=2, ylim=c(0,2.5),
        lwd=lwd, boxwex=boxwex, frame=F, col=colors.class,
        at=posvec, axes=FALSE
)
axis(2, cex.axis=x.cex, las=2, lwd=lwd, lwd.ticks=lwd.tick)

dev.off()

###

filename = paste(path, "/figures/E5-somaarea-boxplot-nes0-nesm-with-datapoints.tiff", sep="")
tiff(filename, width=img.w, height=img.h, units=img.u, res=300, compression = "jpeg")

par(mar = marvec + 0.1)
posvec = c(1,2.5,4)

boxplot(tmpdf$soma_Area[which(tmpdf$class == "Nuc")], 
        tmpdf$soma_Area[which(tmpdf$class == "Misloc_1")],
        tmpdf$soma_Area[which(tmpdf$class == "Misloc_2")],
        
        outline=F, las=2, ylim=c(0,3.5),
        lwd=lwd, boxwex=boxwex, frame=F, col=rep(col.bin, 3),
        at=posvec, axes=FALSE
)
axis(2, cex.axis=x.cex, las=2, lwd=lwd, lwd.ticks=lwd.tick)


# Step 3: Overlay individual points, colored by replicate

classvec = c("Nuc", "Misloc_1", "Misloc_2")
repvec = c("R1", "R2", "R3")
rep.posvec = c(-0.25, 0, 0.25)

numdp.df = data.frame(matrix(0, nrow=length(classvec), ncol=length(repvec)))
rownames(numdp.df) = classvec
colnames(numdp.df) = repvec

for (i in 1:length(classvec)) {
  subset_data <- tmpdf[which(tmpdf$class == classvec[i]), c("replicate", "soma_Area")]
  colnames(subset_data)[2] = "value"
  
  for (j in 1:length(repvec)) {
    repdata = subset_data$value[which(subset_data$replicate == repvec[j])]
    points(jitter(rep(posvec[i]+rep.posvec[j], length(repdata)), amount=0.1), repdata, col = colors[as.numeric(j)], pch = 20, cex=cexval)
    
    numdp.df[i,j] = length(repdata)
  }
}

dev.off()

numdp.df$class = rownames(numdp.df)
write.table(numdp.df, file = paste(path, "/figures/E5-somaarea-boxplot-nes0-nesm-with-datapoints_numbers.txt", sep=""), sep="\t", 
            col.names = T, row.names = F, quote = F)

###############################################################################
## plot the NC values per bin

filename = paste(path, "/figures/E5-neusoma-boxplot-v11-low-med-high-display-NC-with-datapoints.tiff", sep="")
tiff(filename, width=img.w, height=img.h, units=img.u, res=300, compression = "jpeg")

par(mar = marvec + 0.1)
posvec = c(1,2.5,4)

boxplot(tmpdf$cyto_nuc[which(tmpdf$class == "Nuc")], 
        tmpdf$cyto_nuc[which(tmpdf$class == "Misloc_1")],
        tmpdf$cyto_nuc[which(tmpdf$class == "Misloc_2")],
        
        outline=F, las=2, ylim=c(0,100),
        lwd=lwd, boxwex=boxwex, frame=F, col=rep(col.bin, 3),
        at=posvec, axes=FALSE
)
axis(2, cex.axis=x.cex, las=2, lwd=lwd, lwd.ticks=lwd.tick)


# Step 3: Overlay individual points, colored by replicate

classvec = c("Nuc", "Misloc_1", "Misloc_2")
repvec = c("R1", "R2", "R3")
rep.posvec = c(-0.25, 0, 0.25)

numdp.df = data.frame(matrix(0, nrow=length(classvec), ncol=length(repvec)))
rownames(numdp.df) = classvec
colnames(numdp.df) = repvec

for (i in 1:length(classvec)) {
  subset_data <- tmpdf[which(tmpdf$class == classvec[i]), c("replicate", "cyto_nuc")]
  colnames(subset_data)[2] = "value"
  
  for (j in 1:length(repvec)) {
    repdata = subset_data$value[which(subset_data$replicate == repvec[j])]
    points(jitter(rep(posvec[i]+rep.posvec[j], length(repdata)), amount=0.1), repdata, col = colors[as.numeric(j)], pch = 20, cex=cexval)
    
    numdp.df[i,j] = length(repdata)
  }
}

dev.off()

numdp.df$class = rownames(numdp.df)
write.table(numdp.df, file = paste(path, "/figures/E5-neusoma-boxplot-v11-low-med-high-display-NC-with-datapoints_numbers.txt", sep=""), sep="\t", 
            col.names = T, row.names = F, quote = F)

###############################################################################

#################################################################################
### Plot aggregates
### at 20x pico pixel size is 0.345um


library(vioplot)

pixelarea = 0.345*0.345

tmpdf = celldf[which(celldf$sample == "nesm"), c("replicate", "aggmaxsize", "aggsize", "aggnum", "soma_Area", "cyto_nuc")]


## without considering classes

aggper.df = data.frame(matrix(0, nrow=3, ncol=3))
sizevec = c(1, 3, 5)
colnames(aggper.df) = c("s1", "s2", "s3")
for(r in 1:length(repvec)){
  
  aggvec = tmpdf$aggmaxsize[which(tmpdf$replicate == repvec[r])]*pixelarea
  per = unlist(sapply(sizevec, function(s){ length(which(aggvec>s)) }) ) * 100/ length(aggvec)
  aggper.df[r,] = per
}

filename = paste(path, "/figures/E5-aggregates-max-percent-barplot-hard-thresh-low-med-high.tiff", sep="")
tiff(filename, width=img.w, height=img.h, units=img.u, res=300, compression = "jpeg")

par(mar = c(5, 12, 4, 2) + 0.1)
posvec = c(1,2.5,4)

boxplot(aggper.df$s1, aggper.df$s2, aggper.df$s3, col = c("darkolivegreen1", "aquamarine2", "chartreuse3"), beside=T, las=1, lwd=2, axes=F,
        names.arg = c(">1um2", ">3um2", ">5um2"), ylim=c(0,50), at = posvec)

axis(2, cex.axis=x.cex, las=1, lwd=lwd, lwd.ticks=lwd.tick, ylim=c(0,50))

for (i in 1:length(repvec)) {
  
  repdata = aggper.df[i,]
  points(posvec, repdata, col = "red", pch = 19, cex = 1.5)
  
}

dev.off()


################################################################################
###################################################################################################


